package com.hero.ui.dialog;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

import com.hero.HeroDesigner;
import com.hero.objects.powers.Summon;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class SummonDialog extends PowerDialog {

	private static final long serialVersionUID = -1224455897089997949L;

	JButton fileAssociationBtn;

	public SummonDialog(Summon pk, boolean isNew) {
		super(pk, isNew, true);
	}

	@Override
	protected JPanel getModsPanel() {
		JPanel mods = new JPanel(new FlowLayout(FlowLayout.CENTER));
		mods.add(fileAssociationBtn);
		mods.add(customAdderBtn);
		mods.add(privateAdderBtn);
		mods.add(addModifierBtn);
		return mods;
	}

	@Override
	protected void initListeners() {
		super.initListeners();

		fileAssociationBtn.addActionListener(new ActionListener() {
			JFileChooser chooser;

			public void actionPerformed(ActionEvent e) {
				File openFile = null;
				Summon f = (Summon) power;
				if ((f.getFilePath() != null)
						&& (f.getFilePath().trim().length() > 0)) {
					f.clearFilePath();
					fileAssociationBtn.setText("Associate File...");
					updateValues();
					return;
				} else {
					while (openFile == null) {
						if (chooser == null) {
							chooser = new JFileChooser();
							chooser
									.setFileFilter(new javax.swing.filechooser.FileFilter() {

										@Override
										public boolean accept(File file) {
											if (file.isDirectory()
													&& !file.getName()
															.toUpperCase()
															.endsWith(".PKG")
													&& !file.getName()
															.toUpperCase()
															.endsWith(".APP")) {
												return true;
											}
											if (file.getName().toUpperCase()
													.endsWith(".HDC")) {
												return true;
											} else {
												return false;
											}
										}

										@Override
										public String getDescription() {
											return "Hero Designer Character Files";
										}
									});
							chooser.setApproveButtonText("Associate Character");
							chooser.setDialogTitle("Open");
							chooser
									.setFileSelectionMode(JFileChooser.FILES_ONLY);
							chooser.setMultiSelectionEnabled(false);
							chooser.setAcceptAllFileFilterUsed(false);
							if ((HeroDesigner.getInstance().getPrefs()
									.getSaveDir() != null)
									&& (HeroDesigner.getInstance().getPrefs()
											.getSaveDir().trim().length() > 0)) {
								try {
									chooser.setCurrentDirectory(new File(
											HeroDesigner.getInstance()
													.getPrefs().getSaveDir()));
								} catch (Exception ex) {
								}
							}
						}
						int ret = chooser.showOpenDialog(SummonDialog.this);
						if (ret == JFileChooser.CANCEL_OPTION) {
							return;
						} else if (ret == JFileChooser.APPROVE_OPTION) {
							openFile = chooser.getSelectedFile();
							if (!openFile.exists()) {
								openFile = null;
							}
						}
					}
					if ((openFile == null) || openFile.isDirectory()) {
						return;
					}

					((Summon) power).setFilePath(openFile.getAbsolutePath());
					levelTF.setCurrent(((Summon) power).getLevels());
					fileAssociationBtn.setText("Remove File Association");
					updateValues();
				}
			}
		});
	}

	@Override
	protected void initWidgets() {
		super.initWidgets();
		fileAssociationBtn = new JButton("Associate File...");
		Summon f = (Summon) power;
		if ((f.getFilePath() != null) && (f.getFilePath().trim().length() > 0)) {
			fileAssociationBtn.setText("Remove File Association");
		}
	}

	@Override
	public void updateValues() {
		super.updateValues();
		Summon check = (Summon) power;
		if (check.getFilePath() != null) {
			File file = new File(check.getFilePath());
			damageLbl.setText(power.getDamageDisplay() + " (associated with "
					+ file.getName() + ")");
		} else {
			damageLbl.setText(power.getDamageDisplay());
		}
	}
}